<?php

require '../autoloader.php';

use OpenBoleto\Banco\Caixa;
use OpenBoleto\Agente;

$sacado = new Agente('Cliente Teste 10', 
    '974.943.700-48', 
    'Rua dos Testes 1 23', 
    '95650-000', 
    'Igrejinha', 'RS');


$cedente = new Agente('CRISDU MODA INTIMA LTDA', 
    '07.318.638/0001-14', 
    'Rua Santa Catarina 650', 
    '95650-000', 
    'Igrejinha', 
    'RS');

$boleto = new Caixa(array(
    // Parâmetros obrigatórios
    'dataVencimento' => new DateTime("05-10-2020"),
    'valor' => 179.90,
    'sequencial' => 1,
    'sacado' => $sacado,
    'cedente' => $cedente,
    'agencia' => '2515', // Até 4 dígitos
    'carteira' => 'RG', // SR => Sem Registro ou RG => Registrada
    'conta' => '818889', // Até 6 dígitos

    // Parâmetros recomendáveis
    //'logoPath' => 'http://empresa.com.br/logo.jpg', // Logo da sua empresa
    'contaDv' => 0,
    'agenciaDv' => null,
    'descricaoDemonstrativo' => array( // Até 5
        'Incluir aqui informacoes',
        'Que julgarmos pertinentes',
    ),
    'instrucoes' => array( // Até 8
        'Após 5 dias do vencimento, cobrar 1% de',
        'multa e 1% de juros ao dia',
    ),

    // Parâmetros opcionais
    //'resourcePath' => '../resources',
    //'moeda' => Caixa::MOEDA_REAL,
    //'dataDocumento' => new DateTime(),
    //'dataProcessamento' => new DateTime(),
    //'contraApresentacao' => true,
    //'pagamentoMinimo' => 23.00,
    //'aceite' => 'N',
    //'especieDoc' => 'ABC',
    'numeroDocumento' => '12323434',
    //'usoBanco' => 'Uso banco',
    //'layout' => 'caixa.phtml',
    //'logoPath' => 'http://boletophp.com.br/img/opensource-55x48-t.png',
    //'sacadorAvalista' => new Agente('Antônio da Silva', '02.123.123/0001-11'),
    //'descontosAbatimentos' => 123.12,
    //'moraMulta' => 123.12,
    //'outrasDeducoes' => 123.12,
    //'outrosAcrescimos' => 123.12,
    //'valorCobrado' => 123.12,
    //'valorUnitario' => 123.12,
    //'quantidade' => 1,
));

echo $boleto->getOutput();
